from email.policy import default
import streamlit as st
import pandas as pd
import json
from texts import *
import os
from copy import deepcopy
import time
import random

import streamlit as st
import time
from datetime import datetime


# Set up the Streamlit page configuration
st.set_page_config(page_title="Convincingness and Emotions in Arguments")



st.markdown("""
    <style>
        /* Sticky argument styling */
        .sticky-argument {
            position: sticky;
            top: 0;
            background-color: white; /* Optional: Add a background color */
            z-index: 1000; /* Ensure it stays on top */
            padding: 10px; /* Optional: Add some padding */
            border-bottom: 2px solid #f0f0f0; /* Optional: Add a bottom border for separation */
        }

        /* Ensure the parent container allows scrolling */
        .main {
            overflow: visible !important;
        }

        /* Adjust padding for Streamlit's main content */
        .css-18e3th9 {
            padding-top: 1rem !important; /* Add some padding back */
        }

        /* Adjust padding for Streamlit's sidebar */
        .css-1d391kg {
            padding-top: 1rem !important; /* Add some padding back */
        }

        /* Argument box styling */
        # .argument-box {
        #     background-color: #333333; /* Light grey background */
        #     color: #ffffff; /* White font color */
        #     border: 1px solid #ccc; /* Add a border around the box */
        #     border-radius: 0px; 
        #     padding: 10px; /* Add padding inside the box */
        #     font-family: 'Courier New', Courier, monospace; 
        #     font-size: 16px; 
        #     line-height: 1.2; /* Adjust line spacing */
        #     word-wrap: break-word; /* Break words if necessary */
        #     overflow: visible; /* Prevent horizontal scrollbars */
        #     margin-bottom: 20px; /* Add space after the box */
        #     text-indent: 0;
        #     display: block; /* Ensure it behaves like a block element */
        # }

        /* Argument box styling */
        .argument-box {
            background-color: #004d40; /* Dark green background for distinction */
            color: #ffffff; /* White font color */
            border: 1px solid #ccc; /* Add a border around the box */
            border-radius: 0px; 
            padding: 10px; /* Add padding inside the box */
            font-family: 'Courier New', Courier, monospace; 
            font-size: 16px; 
            line-height: 1.2; /* Adjust line spacing */
            word-wrap: break-word; /* Break words if necessary */
            overflow: visible; /* Prevent horizontal scrollbars */
            margin-bottom: 20px; /* Add space after the box */
            text-indent: 0;
            display: block; /* Ensure it behaves like a block element */
        }

        /* Statement box styling */
        .statement-box {
            background-color: #005f73; /* Teal background for distinction */
            color: #ffffff; /* White font color */
            border: 1px solid #ccc; /* Add a border around the box */
            border-radius: 0px; 
            padding: 10px; /* Add padding inside the box */
            font-family: 'Courier New', Courier, monospace; 
            font-size: 16px; 
            line-height: 1.2; /* Adjust line spacing */
            word-wrap: break-word; /* Break words if necessary */
            overflow: visible; /* Prevent horizontal scrollbars */
            margin-bottom: 20px; /* Add space after the box */
            text-indent: 0;
            display: block; /* Ensure it behaves like a block element */
        }

                /* Role-playing scenario box styling */
        .roleplay-box {
            background-color: #f4e4c1; /* Light parchment-like background */
            color: #4b2e05; /* Dark brown font color for a thematic look */
            border: 2px solid #d2b48c; /* Tan border to complement the background */
            border-radius: 10px; /* Rounded corners for a softer look */
            padding: 15px; /* Add padding inside the box */
            font-family: 'Georgia', serif; /* A serif font for a classic feel */
            font-size: 18px; /* Slightly larger font size for readability */
            line-height: 1.5; /* Adjust line spacing for better readability */
            word-wrap: break-word; /* Break words if necessary */
            overflow: visible; /* Prevent horizontal scrollbars */
            margin-bottom: 20px; /* Add space after the box */
            # text-indent: 20px; /* Indent the first line for a storytelling feel */
            display: block; /* Ensure it behaves like a block element */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); /* Add a subtle shadow for depth */
        }

        .speaker-box {
            background-color: #e0f7fa;
            color: #004d40; 
            border: 2px solid #00796b;
            padding: 15px; /* Add padding inside the box */
            font-family: 'Courier New', Courier, monospace; 
            font-size: 16px; 
            line-height: 1.2; /* Adjust line spacing */
            word-wrap: break-word; /* Break words if necessary */
            overflow: visible; /* Prevent horizontal scrollbars */
            margin-bottom: 20px; /* Add space after the box */
            display: block; /* Ensure it behaves like a block element */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2); /* Add a subtle shadow for depth */
        }

        .horizontal-radio .stRadio {
            display: flex;
            flex-direction: row; /* Align radio buttons horizontally */
        }
        .horizontal-radio .stRadio div {
            margin-right: 10px; /* Add spacing between options */
        }
    </style>
""", unsafe_allow_html=True)


js = '''
<script>
    var body = window.parent.document.querySelector(".main");
    console.log(body);
    body.scrollTop = 0;
</script>
'''

def load_study_file(prolific_id):
    import os
    import json
    import streamlit as st

    # replace with your directory path
    directory = "your_directory"
    required_items = {"complete"}
    found_files = []
    incomplete_files = []

    # Ensure the directory exists
    if not os.path.exists(directory):
        os.makedirs(directory)

    # Search for files containing the Prolific ID in the name
    for filename in os.listdir(directory):
        if prolific_id in filename and filename.endswith(".json"):
            filepath = os.path.join(directory, filename)
            found_files.append(filepath)

            # Check file completeness
            with open(filepath, "r") as f:
                data = json.load(f)
            if not required_items.issubset(data.keys()) or not data.get("complete", False):
                incomplete_files.append(filepath)

    if incomplete_files:
        # filepath = incomplete_files[0]
        st.write("You have an incomplete survey. Please continue where you left off.")
        if st.button(f"Resume {os.path.basename(filepath)}"):
            with open(filepath, "r") as f:
                st.session_state["survey"] = json.load(f)
                # Ensure "instance" is a list and not empty
                if not isinstance(st.session_state["survey"].get("instance"), list) or not st.session_state["survey"]["instance"]:
                    st.error("Survey file is corrupted or incomplete. Please contact support.")
                    return
            st.session_state["survey_path"] = filepath
            st.session_state.page += 1
            st.rerun()

    else:
        # No incomplete survey, create a new one
        create_new_file(prolific_id, len(found_files) + 1, directory)
        st.session_state.page += 1
        st.rerun()


def create_new_file(prolific_id, study_number, directory):
    new_file_path = os.path.join(directory, f"{prolific_id}_{study_number}.json")
    st.session_state["survey_path"] = new_file_path

    st.session_state["survey"] = {
        "instance": [],
        "responses": {},
        "complete": False
    }

    sample_data(prolific_id)
    # Check if sampling succeeded
    if not st.session_state["survey"]["instance"]:
        st.error("Could not sample arguments for this participant. Please try again later or contact the researcher.")
        st.stop()
    save_survey()



def save_survey():
    """
    Save the survey data, combining instance data with responses.
    """
    # Combine instance data with responses
    annotated_instances = []
    for instance in st.session_state["survey"]["instance"]:
        # Create a copy of the instance and add the corresponding responses
        annotated_instance = instance.copy()
        annotated_instance.update(st.session_state["survey"]["responses"])
        annotated_instances.append(annotated_instance)

    # Add argument pair ID and individual argument IDs to the responses
    pair_id = st.session_state["survey"]["instance"][0]["pair_id"] 
    argument_1_id = st.session_state["survey"]["instance"][0]["ID"]
    argument_1_speaker_age = st.session_state ["survey"]["instance"][0]["speaker_age"]
    argument_1_speaker_gender = st.session_state ["survey"]["instance"][0]["speaker_gender"]
    argument_2_id = st.session_state["survey"]["instance"][1]["ID"]
    argument_2_speaker_age = st.session_state ["survey"]["instance"][1]["speaker_age"]
    argument_2_speaker_gender = st.session_state ["survey"]["instance"][1]["speaker_gender"]
    arguments = [instance["argument"] for instance in st.session_state["survey"]["instance"]]

    survey_data = {
        "instance": st.session_state["survey"]["instance"],
        "responses": {
            **st.session_state["survey"]["responses"],
            "pair_id": pair_id, 
            "argument_1_id": argument_1_id,
            "argument_1_speaker_age": argument_1_speaker_age,
            "argument_1_speaker_gender": argument_1_speaker_gender,
            "argument_2_id": argument_2_id, 
            "argument_2_speaker_age": argument_2_speaker_age,
            "argument_2_speaker_gender": argument_2_speaker_gender,
            "arguments": arguments, 
        }
    }

    # Save the survey data to the file
    with open(st.session_state.survey_path, 'w') as f:
        json.dump(survey_data, f, indent=4)




def initialize_tracker(data_file, tracker_file):
    """
    Initialize the annotation tracker file if it doesn't exist.
    """
    if not os.path.exists(tracker_file):
        # Load the dataset
        data = pd.read_csv(data_file)
        if "ID" not in data.columns:
            st.error("'ID' column missing in the dataset.")
            return

        # Create the tracker file
        tracker = pd.DataFrame({
            "argument_id": data["ID"],
            "annotations_completed": 0,
            "currently_annotated": [[] for _ in range(len(data))],  # List of annotators currently working
            "annotators": [[] for _ in range(len(data))]  # List of annotators who completed the annotation
        })
        tracker.to_csv(tracker_file, index=False)
        st.write(f"Tracker file created at {tracker_file}")
    else:
        st.write(f"Tracker file already exists at {tracker_file}")


def update_tracker_on_start(tracker_file, selected_arguments, prolific_id):
    """
    Update the tracker when an annotator starts annotating.
    """
    tracker = pd.read_csv(tracker_file)

    # Safely process the currently_annotated and annotators columns
    def safe_eval(val):
        if isinstance(val, str):
            try:
                return eval(val)
            except:
                return []
        elif isinstance(val, list):
            return val
        else:
            return []

    tracker["currently_annotated"] = tracker["currently_annotated"].apply(safe_eval)
    tracker["annotators"] = tracker["annotators"].apply(safe_eval)

    # Mark the arguments as currently being annotated by the user
    for argument_id in selected_arguments["ID"]:
        if prolific_id not in tracker.loc[tracker["argument_id"] == argument_id, "currently_annotated"].values[0]:
            tracker.loc[tracker["argument_id"] == argument_id, "currently_annotated"].values[0].append(prolific_id)

    tracker.to_csv(tracker_file, index=False)


def update_tracker_on_finalize(tracker_file, prolific_id, completed, selected_arguments):
    """
    Update the tracker when an annotator finishes or abandons the study.
    """
    tracker = pd.read_csv(tracker_file)

    # Safely process the currently_annotated and annotators columns
    def safe_eval(val):
        if isinstance(val, str):
            try:
                return eval(val)
            except:
                return []
        elif isinstance(val, list):
            return val
        else:
            return []

    tracker["currently_annotated"] = tracker["currently_annotated"].apply(safe_eval)
    tracker["annotators"] = tracker["annotators"].apply(safe_eval)

    if completed:
        # Increment annotations_completed and log the annotator's ID
        for argument_id in selected_arguments["ID"]:
            tracker.loc[tracker["argument_id"] == argument_id, "annotations_completed"] += 1
            if prolific_id not in tracker.loc[tracker["argument_id"] == argument_id, "annotators"].values[0]:
                tracker.loc[tracker["argument_id"] == argument_id, "annotators"].values[0].append(prolific_id)
            # Remove the annotator from currently_annotated
            tracker.loc[tracker["argument_id"] == argument_id, "currently_annotated"].values[0].remove(prolific_id)
    else:
        # Clear the annotator from currently_annotated without incrementing annotations_completed
        for argument_id in selected_arguments["ID"]:
            if prolific_id in tracker.loc[tracker["argument_id"] == argument_id, "currently_annotated"].values[0]:
                tracker.loc[tracker["argument_id"] == argument_id, "currently_annotated"].values[0].remove(prolific_id)

    tracker.to_csv(tracker_file, index=False)




def sample_data(prolific_id, sample_size=2):
    """
    Sample two arguments from the same topic for the filler study, using the unified tracker and data file.
    """
    import pandas as pd
    import random

    base_dir = os.path.dirname(os.path.abspath(__file__))
    data_file = os.path.join(base_dir, "dataset/data_main", 'your_data.csv')
    tracker_file = os.path.join(base_dir, "user_data", "annotation_tracker.csv")

    # Initialize the tracker file if needed
    if not os.path.exists(tracker_file):
        data = pd.read_csv(data_file)
        tracker = pd.DataFrame({
            "argument_id": data["ID"],
            "topic": data["topic"],
            "annotations_completed": data["annotation_count"] if "annotation_count" in data.columns else 0,
            "currently_annotated": [[] for _ in range(len(data))],
            "annotators": [[] for _ in range(len(data))]
        })
        tracker.to_csv(tracker_file, index=False)

    data = pd.read_csv(data_file)
    tracker = pd.read_csv(tracker_file)

    def safe_eval(val):
        if isinstance(val, str):
            try:
                return eval(val)
            except:
                return []
        elif isinstance(val, list):
            return val
        else:
            return []

    tracker["currently_annotated"] = tracker["currently_annotated"].apply(safe_eval)
    tracker["annotators"] = tracker["annotators"].apply(safe_eval)

    # Exclude arguments already annotated by this participant in the filler study
    already_annotated = tracker[tracker["annotators"].apply(lambda x: prolific_id in x)]["argument_id"].tolist()
    incomplete = tracker[tracker["annotations_completed"] < 5]
    incomplete = incomplete[~incomplete["argument_id"].isin(already_annotated)]

    topics = incomplete["topic"].unique().tolist()
    random.shuffle(topics)
    selected = None
    for topic in topics:
        topic_args = incomplete[incomplete["topic"] == topic]
        if len(topic_args) >= 2:
            selected = topic_args.sample(n=2, random_state=random.randint(0, 10000))
            break
        elif len(topic_args) == 1:
            arg_id = topic_args.iloc[0]["argument_id"]
            fully_annotated = tracker[
                (tracker["topic"] == topic) &
                (tracker["annotations_completed"] >= 5) &
                (~tracker["argument_id"].isin(already_annotated)) &
                (tracker["argument_id"] != arg_id)
            ]
            if not fully_annotated.empty:
                selected = pd.concat([topic_args, fully_annotated.sample(n=1, random_state=random.randint(0, 10000))])
                break
    if selected is None:
        st.error("No available arguments for annotation. All arguments have been fully annotated or are in progress.")
        return

    selected_data = data[data["ID"].isin(selected["argument_id"])]
    pair_id = f"{selected_data.iloc[0]['ID']}_{selected_data.iloc[1]['ID']}"
    selected_data = selected_data.copy()
    selected_data["pair_id"] = pair_id

    # Update tracker to mark these arguments as being annotated by this user
    tracker["currently_annotated"] = tracker["currently_annotated"].apply(safe_eval)
    for argument_id in selected_data["ID"]:
        idx = tracker[tracker["argument_id"] == argument_id].index[0]
        if prolific_id not in tracker.at[idx, "currently_annotated"]:
            tracker.at[idx, "currently_annotated"].append(prolific_id)
    tracker.to_csv(tracker_file, index=False)

    # Store in your existing session state structure
    st.session_state["survey"]["instance"] = selected_data.to_dict(orient="records")





def finalize_annotations(prolific_id, completed):
    import pandas as pd
    import os

    base_dir = os.path.dirname(os.path.abspath(__file__))
    tracker_file = os.path.join(base_dir, "user_data", "annotation_tracker_filler.csv")

    # Get the argument IDs from the current survey instance
    if "survey" not in st.session_state or "instance" not in st.session_state["survey"]:
        st.warning("No survey instance found in session state. Nothing to finalize.")
        return

    argument_ids = [arg["ID"] for arg in st.session_state["survey"]["instance"]]

    tracker = pd.read_csv(tracker_file)

    def safe_eval(val):
        if isinstance(val, str):
            try:
                return eval(val)
            except:
                return []
        elif isinstance(val, list):
            return val
        else:
            return []

    tracker["currently_annotated"] = tracker["currently_annotated"].apply(safe_eval)
    tracker["annotators"] = tracker["annotators"].apply(safe_eval)

    for argument_id in argument_ids:
        idx = tracker[tracker["argument_id"] == argument_id].index
        if len(idx) == 0:
            continue  # Argument not found
        idx = idx[0]
        # Remove from currently_annotated
        curr_annot = tracker.at[idx, "currently_annotated"]
        if prolific_id in curr_annot:
            curr_annot.remove(prolific_id)
        tracker.at[idx, "currently_annotated"] = curr_annot
        # If completed, increment annotation count and add annotator
        if completed:
            tracker.at[idx, "annotations_completed"] = int(tracker.at[idx, "annotations_completed"]) + 1
            annots = tracker.at[idx, "annotators"]
            if prolific_id not in annots:
                annots.append(prolific_id)
            tracker.at[idx, "annotators"] = annots

    tracker.to_csv(tracker_file, index=False)




def cross_join(left, right):
    new_rows = [] if right else left
    for left_row in left:
        for right_row in right:
            temp_row = deepcopy(left_row)
            for key, value in right_row.items():
                temp_row[key] = value
            new_rows.append(deepcopy(temp_row))
    return new_rows


def flatten_list(data):
    for elem in data:
        if isinstance(elem, list):
            yield from flatten_list(elem)
        else:
            yield elem


def json_to_dataframe(data_in):
    def flatten_json(data, prev_heading=''):
        if isinstance(data, dict):
            rows = [{}]
            for key, value in data.items():
                rows = cross_join(rows, flatten_json(value, prev_heading + '.' + key))
        elif isinstance(data, list):
            rows = []
            for item in data:
                [rows.append(elem) for elem in flatten_list(flatten_json(item, prev_heading))]
        else:
            rows = [{prev_heading[1:]: data}]
        return rows

    return pd.DataFrame(flatten_json(data_in))



def save_all_responses():
    """
    Consolidate all responses into a single CSV file, including instance data, labels, and participant IDs.
    """
    output_file = "user_data/all_responses.csv"
    surveys_dir = "user_data/surveys_main/"

    all_data = []  # List to store all annotated instances

    # Read all JSON files in the directory
    json_files = [f for f in os.listdir(surveys_dir) if f.endswith('.json')]
    for json_file in json_files:
        json_file_path = os.path.join(surveys_dir, json_file)

        # Read the JSON file
        with open(json_file_path, 'r') as file:
            json_data = json.load(file)

        # Extract participant ID and pair ID
        participant_id = json_data["responses"].get("participant_id", "Unknown")  # Default to "Unknown" if not present
        pair_id = json_data["responses"].get("pair_id", "Unknown")  # Default to "Unknown" if not present
        arguments = json_data["responses"].get("arguments", [])  # Default to an empty list if not present


    all_responses = pd.DataFrame(all_data)
    all_responses.to_csv(output_file, index=False)



def change_font_size(text, font_size='large'):
    return rf"$\textsf{{\{font_size} {{{text}}}}}$"




# Initialize session state variables for timing
if "page_start_time" not in st.session_state:
    st.session_state["page_start_time"] = time.time()  # Start time for the current page
if "last_interaction_time" not in st.session_state:
    st.session_state["last_interaction_time"] = time.time()  # Last interaction time
if "time_spent_per_page" not in st.session_state:
    st.session_state["time_spent_per_page"] = {}  # Dictionary to store time spent on each page
if "total_time" not in st.session_state:
    st.session_state["total_time"] = 0  # Total time spent across all pages





# Function for next button only
def next_back_buttons(post_complete=False, validation_keys=None):
    col1, col2, col3 = st.columns([1, 8, 1]) 

    with col3:  # "Next" button
        next_button = st.button("Next")

    # Handling button functionality
    if next_button:
        # Ensure validation_keys is a list
        if validation_keys and isinstance(validation_keys, str):
            validation_keys = [validation_keys]

        # Perform validation if validation_keys are provided
        if validation_keys:
            # Check if any mandatory question is unanswered
            if any(st.session_state["survey"]["responses"].get(key) in [None, ""] for key in validation_keys):
                # Set validation error flag in session state
                st.session_state["validation_error"] = True
                return  # Stop execution to prevent page navigation
            else:
                # Clear validation error if validation passes
                st.session_state["validation_error"] = False

        if post_complete:
            st.session_state.post = ""
            st.session_state.page = 44
            save_survey()
            st.rerun()
        else:
            st.session_state.page += 1  # Move to the next page
            save_survey()
            st.rerun()




# Initialize session states if not set
if "page" not in st.session_state:
    st.session_state.page = 1
if "survey" not in st.session_state:
    st.session_state.survey = {"instance": {}, "responses": {}}
if "prolific_id" not in st.session_state:
    st.session_state.prolific_id = None
if "survey_path" not in st.session_state:
    st.session_state.survey_path = None

# Set number of arguments to be annotated per survey
survey_sample_size = 2


# Define page functions
def page_1_welcome():

    # if "survey_start_time" not in st.session_state:
    #     st.session_state["survey_start_time"] = time.time()

    st.title(study_data["welcome"])
    st.subheader(study_data["welcome_subheader"])
    st.markdown(study_data["intro_text"])
    st.divider()
    st.markdown(study_data["warning_text"])
    st.divider()

    col1, col2 = st.columns([.5, 18])  # Adjust column ratios as needed

    with col1:
        agreed = st.checkbox("  ")

    with col2:
        st.markdown(study_data["consent_text"])

    # Proceed to next page if consent is given and Prolific ID is entered
    if agreed:
        st.session_state.prolific_id = st.text_input(label=ui_texts['instructions']['prolific'])

        st.session_state['survey']['agreed'] = str(agreed)
        st.session_state['survey']['prolific_id'] = st.session_state.prolific_id
        if st.button(ui_texts['buttons']['next']):
            if not st.session_state.prolific_id:
                st.error(ui_texts['errors']['prolific_mandatory'])
            else:
                st.session_state.page += 1
                st.rerun()


def page_2_loading_survey():
    st.title("Loading Survey")
    # Check for previous incomplete surveys
    load_study_file(st.session_state.prolific_id)


def page_emotional_state():
    st.title("About your emotional state.")
    st.markdown("""First, we want to know more about you. Please tell us about your current emotional state. <br>
    For each emotion, answer to which extent you currently feel it.""" , unsafe_allow_html=True)

    # Define the list of emotions
    emotions = ["Anger", "Boredom", "Disgust", "Fear", "Guilt", "Interest", "Joy", "Pride", "Relief", "Sadness", "Shame", "Surprise", "Trust"]

    # Initialize the session state for each emotion if it doesn't exist
    if "survey" not in st.session_state:
        st.session_state["survey"] = {"responses": {}}
    
    for emotion in emotions:
        if f"current_{emotion}" not in st.session_state["survey"]["responses"]:
            st.session_state["survey"]["responses"][f"current_{emotion}"] = None

    # Render emotion questions with radio buttons
    for emotion in emotions:
        st.session_state["survey"]["responses"][f"current_{emotion}"] = st.radio(
            rf"$\textsf{{\large {{{emotion}}}}}$",
            options=["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
            index=(
                list(["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"]).index(
                    st.session_state["survey"]["responses"][f"current_{emotion}"]
                ) if st.session_state["survey"]["responses"][f"current_{emotion}"] else None
            ),
            key=f"{emotion}_slider",
            horizontal=True
        )

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    next_back_buttons(validation_keys=[f"current_{emotion}" for emotion in emotions])






def page_dummy(next_page):
    instance = st.session_state["survey"]["instance"][0]
    # st.markdown("<div style='height: 1px;'></div>", unsafe_allow_html=True)  # Spacer
    st.title("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    # Simulate a delay before navigating to the next page
    # if you set this too low, the time will not be enough for streamlit to fully execute, so
    # it will look like the page is not working
    time.sleep(0.2)  # Wait for X seconds (adjust as needed)
    st.session_state.page = next_page  # Move to the next page
    st.rerun()


def page_dummy_2(next_page):
    instance = st.session_state["survey"]["instance"][0]
    st.title("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    # Simulate a delay before navigating to the next page
    # if you set this too low, the time will not be enough for streamlit to fully execute, so
    # it will look like the page is not working
    time.sleep(0.8)  # Wait for X seconds (adjust as needed)
    st.session_state.page = next_page  # Move to the next page
    st.rerun()

def page_dummy_3(next_page):
    instance = st.session_state["survey"]["instance"][0]
    # st.markdown("<div style='height: 1px;'></div>", unsafe_allow_html=True)  # Spacer
    st.title("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    st.markdown("")
    # Simulate a delay before navigating to the next page
    # if you set this too low, the time will not be enough for streamlit to fully execute, so
    # it will look like the page is not working
    time.sleep(0.3)  # Wait for X seconds (adjust as needed)
    st.session_state.page = next_page  # Move to the next page
    st.rerun()




def page_participant_personality():
    st.title("About your personality.")
    st.markdown(f"""Now we would like to know more about your personality.
    Here are a number of personality traits that may or may not apply to you. 
    Please select a value below each statement to indicate the extent to which you agree 
    or disagree with that statement. You should rate the extent to which the pair of traits applies 
    to you, even if one characteristic applies more strongly than the other.""", unsafe_allow_html=True)

    # Display the scale explanation
    st.markdown(
        """
        <div style="display: flex; justify-content: space-between; text-align: center;">
            <span>1 = Disagree<br>strongly</span>
            <span>2 = Disagree<br>moderately</span>
            <span>3 = Disagree<br>a little</span>
            <span>4 = Neither agree<br>nor disagree</span>
            <span>5 = Agree<br>a little</span>
            <span>6 = Agree<br>moderately</span>
            <span>7 = Agree<br>strongly</span>
        </div>
        """,
        unsafe_allow_html=True
    )

    # List of personality trait questions
    personality_traits_questions = [
        "I see myself as extraverted, enthusiastic.",
        "I see myself as critical, quarrelsome.",
        "I see myself as dependable, self-disciplined.",
        "I see myself as anxious, easily upset.",
        "I see myself as open to new experiences, complex.",
        "I see myself as reserved, quiet.",
        "I see myself as sympathetic, warm.",
        "I see myself as disorganized, careless.",
        "I see myself as calm, emotionally stable.",
        "I see myself as conventional, uncreative."
    ]

    # List to store the keys for validation
    validation_keys = []

    # Iterate over the personality questions
    for i, trait in enumerate(personality_traits_questions, start=1):
        # Define a unique key for each question
        trait_key = f"personality_participant_{i}"

        # Add the key to the validation list
        validation_keys.append(trait_key)

        # Initialize the session state for this question if it doesn't exist
        if trait_key not in st.session_state["survey"]["responses"]:
            st.session_state["survey"]["responses"][trait_key] = None

        # Render the radio buttons for each question
        st.session_state["survey"]["responses"][trait_key] = st.radio(
            label=trait,
            options=list(range(1, 8)),  # Options from 1 to 7
            index=(
                st.session_state["survey"]["responses"][trait_key] - 1
                if st.session_state["survey"]["responses"][trait_key] else None
            ),
            horizontal=True  # Display options horizontally
        )

    # Display the scale explanation again at the bottom
    st.markdown(
        """
        <div style="display: flex; justify-content: space-between; text-align: center;">
            <span>1 = Disagree<br>strongly</span>
            <span>2 = Disagree<br>moderately</span>
            <span>3 = Disagree<br>a little</span>
            <span>4 = Neither agree<br>nor disagree</span>
            <span>5 = Agree<br>a little</span>
            <span>6 = Agree<br>moderately</span>
            <span>7 = Agree<br>strongly</span>
        </div>
        """,
        unsafe_allow_html=True
    )

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)


def page_stance():
    st.title("Your stance towards the topic.")
    instance = st.session_state["survey"]["instance"][0] if st.session_state["survey"]["instance"] else {"topic": "Sample Topic", "statement": "Sample Statement"}
    st.markdown(f""" In this study you will imagine being a participant in a discussion about a
    given topic. We now would like to know what your stance towards the topic of the discussion is.
    
    The discussion topic is: 
    <div class="statement-box">{instance['topic_normalized']}.
    </div>
    """, unsafe_allow_html=True)

    # Define the key for this question in session state
    stance_key = "stance"

    # Initialize the session state for this question if it doesn't exist
    if stance_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][stance_key] = None

    # Render the radio button and set the default value based on session state
    st.session_state["survey"]["responses"][stance_key] = st.radio(
        f"""Please provide your stance towards the topic.""",
        options=["Strongly agree", "Agree", "Neutral", "Disagree", "Strongly disagree"],
        index=(
            ["Strongly agree", "Agree", "Neutral", "Disagree", "Strongly disagree"].index(
                st.session_state["survey"]["responses"][stance_key]
            )
            if st.session_state["survey"]["responses"][stance_key] else None
        )
    )

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation key to the next_back_buttons function
    next_back_buttons(validation_keys=stance_key)



# Page: Role-playing acenario
def page_role_playing():
    instance = st.session_state["survey"]["instance"][0]
    st.title("Your role-playing scenario.")
    st.markdown("You will now read over the role-playing scenario that you should engage in. Please read it carefully.")
    st.markdown(f""" 
    <div class="roleplay-box">You are in a town hall meeting to discuss the topic: {instance['topic_normalized']}.<br>
   You are in a bustling town hall, a bright room with folding chairs and a low hum of conversation. Posters line the walls, showcasing various perspectives on the issue at hand. A panel of speakers sits at a long table in front, ready to listen as community members approach the podium. The crowd is a mix of familiar faces, local officials, advocates, and reporters poised with cameras. As the moderator calls for public comments, silence falls. Curious and skeptical eyes focus on the podium as each speaker takes their turn.
    </div>
    """, unsafe_allow_html=True)
    next_back_buttons()


def page_participant_investement():
    instance = st.session_state["survey"]["instance"][0]
    st.title("Describe the scene.")
    st.markdown(f""" We now have some questions about the scenario you just read.""")

    # Define keys for the questions
    scenario_key_1 = "thoughts_scenario_1"
    scenario_key_2 = "thoughts_scenario_2"

    # Initialize the session state for these questions if they don't exist
    if scenario_key_1 not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][scenario_key_1] = None
    if scenario_key_2 not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][scenario_key_2] = ""

    # Render the first question as a radio button
    st.session_state["survey"]["responses"][scenario_key_1] = st.radio(
        "How many people are present in the scenario?",
        options=[
            "It is me and a few friends.",
            "It is me and 10 local polititians.",
            "It is a large crowded room with many different people."
        ],
        index=(
            [
                "It is me and a few friends.",
                "It is me and 10 local polititians.",
                "It is a large crowded room with many different people."
            ].index(st.session_state["survey"]["responses"][scenario_key_1])
            if st.session_state["survey"]["responses"][scenario_key_1] else None
        ),
        horizontal=False
    )

    # Render the second question as a text area
    st.session_state["survey"]["responses"][scenario_key_2] = st.text_area(
        "Please write down where you would sit in this room and how you would feel.",
        value=st.session_state["survey"]["responses"][scenario_key_2]
    )

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")
    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=[scenario_key_1, scenario_key_2])





def page_argument_emo_conv():

    # Validate that the instance list has at least one argument
    if "survey" not in st.session_state or "instance" not in st.session_state["survey"] or len(st.session_state["survey"]["instance"]) < 1:
        st.error("Error: The first argument is missing. Please restart the survey or contact support.")
        return

    # Get the argument instance
    instance = st.session_state["survey"]["instance"][0]
    st.title("The argument.")
    st.markdown(f""" We now continue with the scenario. We will now present a speaker and an argument. As a reminder, the topic is "{instance['topic_normalized']}".
    Then we ask you questions about how the argument affects you. Please read the following text carefully.
    
    A person steps onto the stage. 
    <div class="speaker-box">The person is {instance['speaker_age']} {instance['speaker_gender']}.</div>
    The person argues:
    <div class="argument-box">{instance['argument']}
    </div>
    """, unsafe_allow_html=True)

    # Define keys for the questions
    convincingness_key = "argument_1_convincingness"
    manipulation_key = "argument_1_manipulation"
    emotion_ratings_key = "argument_1_emotion_ratings"
    emotion_reason_key = "argument_1_emotion_reason"
    boredom_key = "argument_1_boredom"
    interest_key = "argument_1_interest"

    # Initialize session state for the questions if they don't exist
    if convincingness_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][convincingness_key] = None
    if manipulation_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][manipulation_key] = None
    if emotion_ratings_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][emotion_ratings_key] = {}
    if emotion_reason_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][emotion_reason_key] = ""
    if boredom_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][boredom_key] = None
    if interest_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][interest_key] = None

    st.markdown("Please answer all following questions in your role as a participant in the town hall meeting.")

    # Render the first question: How convincing is this argument?
    st.session_state["survey"]["responses"][convincingness_key] = st.radio(
        rf"$\textsf{{\large How convincing is this argument for you?}}$",
        options=["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
        index=(
            ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"].index(
                st.session_state["survey"]["responses"][convincingness_key]
            )
            if st.session_state["survey"]["responses"][convincingness_key] else None
        ),
        horizontal=True  # Set to horizontal
    )

    st.session_state["survey"]["responses"][boredom_key] = st.radio(
        rf"$\textsf{{\large How bored are you by this argument?}}$",
        options=["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
        index=(
            ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"].index(
                st.session_state["survey"]["responses"][boredom_key]
            )
            if st.session_state["survey"]["responses"][boredom_key] else None
        ),
        horizontal=True  # Set to horizontal
    )

    st.session_state["survey"]["responses"][interest_key] = st.radio(
        rf"$\textsf{{\large How interesting is this argument for you?}}$",
        options=["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
        index=(
            ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"].index(
                st.session_state["survey"]["responses"][interest_key]
            )
            if st.session_state["survey"]["responses"][interest_key] else None
        ),
        horizontal=True  # Set to horizontal
    )


    # Render the second question: Is the person trying to manipulate you?
    st.session_state["survey"]["responses"][manipulation_key] = st.radio(
        rf"$\textsf{{\large Do you feel manipulated by this argument?}}$",
        options=["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
        index=(
            ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"].index(
                st.session_state["survey"]["responses"][manipulation_key])
            if st.session_state["survey"]["responses"][manipulation_key] else None
        ),
        horizontal=True  # Set to horizontal
    )


    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")
    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=[
        convincingness_key, manipulation_key, interest_key, boredom_key
    ])


def page_argument_emo_conv_arg2():
    # Validate that the instance list has at least two arguments
    if "survey" not in st.session_state or "instance" not in st.session_state["survey"] or len(st.session_state["survey"]["instance"]) < 2:
        st.error("Error: The second argument is missing. Please restart the survey or contact support.")
        return

    # Get the second argument instance
    instance = st.session_state["survey"]["instance"][1]
    st.title("The argument.")
    st.markdown(f""" We now continue with the scenario. We will now present a speaker and an argument. As a reminder, the topic is "{instance['topic_normalized']}".
    Then we ask you questions about how the argument affects you. Please read the following text carefully.
    
    A person steps onto the stage. 
    <div class="speaker-box">The person is {instance['speaker_age']} {instance['speaker_gender']}.</div>
    The person argues:
    <div class="argument-box">{instance['argument']}
    </div>
    """, unsafe_allow_html=True)

    # Define keys for the questions
    convincingness_key = "argument_2_convincingness"
    manipulation_key = "argument_2_manipulation"
    emotion_ratings_key = "argument_2_emotion_ratings"
    boredom_key = "argument_2_boredom"
    interest_key = "argument_2_interest"

    # Initialize session state for the questions if they don't exist
    if convincingness_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][convincingness_key] = None
    if manipulation_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][manipulation_key] = None
    if emotion_ratings_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][emotion_ratings_key] = {}
    if boredom_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][boredom_key] = None
    if interest_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][interest_key] = None

    st.markdown("Please answer all following questions in your role as a participant in the town hall meeting.")

    # Render the first question: How convincing is this argument?
    st.session_state["survey"]["responses"][convincingness_key] = st.radio(
        rf"$\textsf{{\large How convincing is this argument for you?}}$",
        options=["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
        index=(
            ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"].index(
                st.session_state["survey"]["responses"][convincingness_key]
            )
            if st.session_state["survey"]["responses"][convincingness_key] else None
        ),
        horizontal=True  # Set to horizontal
    )

    st.session_state["survey"]["responses"][boredom_key] = st.radio(
        rf"$\textsf{{\large How bored are you by this argument?}}$",
        options=["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
        index=(
            ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"].index(
                st.session_state["survey"]["responses"][boredom_key]
            )
            if st.session_state["survey"]["responses"][boredom_key] else None
        ),
        horizontal=True  # Set to horizontal
    )

    st.session_state["survey"]["responses"][interest_key] = st.radio(
        rf"$\textsf{{\large How interesting is this argument for you?}}$",
        options=["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
        index=(
            ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"].index(
                st.session_state["survey"]["responses"][interest_key]
            )
            if st.session_state["survey"]["responses"][interest_key] else None
        ),
        horizontal=True  # Set to horizontal
    )

    # Render the second question: Is the person trying to manipulate you?
    st.session_state["survey"]["responses"][manipulation_key] = st.radio(
        rf"$\textsf{{\large Do you feel manipulated by this argument?}}$",
        options=["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
        index=(
            ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"].index(
                st.session_state["survey"]["responses"][manipulation_key])
            if st.session_state["survey"]["responses"][manipulation_key] else None
        ),
        horizontal=True  # Set to horizontal
    )


    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=[
        convincingness_key, manipulation_key, interest_key, boredom_key
    ])




def page_argument_emotion():

    # Validate that the instance list has at least one argument
    if "survey" not in st.session_state or "instance" not in st.session_state["survey"] or len(st.session_state["survey"]["instance"]) < 1:
        st.error("Error: The first argument is missing. Please restart the survey or contact support.")
        return

    # Get the argument instance
    instance = st.session_state["survey"]["instance"][0]
    st.title("Your emotional reaction.")
    st.markdown(f""" We now would like to know which emotion(s) you feel when hearing the argument.
    As a reminder, the topic is "{instance['topic_normalized']}".
    Here is a reminder of the scenario and argument:<br>
    A person steps onto the stage. 
    <div class="speaker-box">The person is {instance['speaker_age']} {instance['speaker_gender']}.</div>
    The person argues:
    <div class="argument-box">{instance['argument']}
    </div>
    """, unsafe_allow_html=True)

    # Define keys for the questions
    emotion_ratings_key = "argument_1_emotion_ratings"
    emotion_reason_key = "argument_1_emotion_reason"
    tie_breaker_key = "argument_1_tie_breaker"

    # Initialize session state for the questions if they don't exist
    if "survey" not in st.session_state:
        st.session_state["survey"] = {"responses": {}}
    if emotion_ratings_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][emotion_ratings_key] = {}
    if emotion_reason_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][emotion_reason_key] = ""
    if tie_breaker_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][tie_breaker_key] = None

    st.markdown("Please answer all following questions in your role as a participant in the town hall meeting.")

    # Render the third question: Rate your emotions
    st.markdown(rf"$\textsf{{\large How strongly do you feel the following emotions when hearing the argument?}}$")
    emotions = ["Anger", "Disgust", "Fear", "Guilt", "Joy", "Pride", "Relief", "Sadness", "Shame", "Surprise", "Trust"]

    # Initialize emotion ratings if not already set
    for emotion in emotions:
        if emotion not in st.session_state["survey"]["responses"][emotion_ratings_key]:
            st.session_state["survey"]["responses"][emotion_ratings_key][emotion] = None

    # Render a rating scale for each emotion
    scale = ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"]
    for emotion in emotions:
        st.session_state["survey"]["responses"][emotion_ratings_key][emotion] = st.radio(
            rf"$\textsf{{\large {{{emotion}}}}}$",
            options=scale,
            index=(
                scale.index(st.session_state["survey"]["responses"][emotion_ratings_key][emotion])
                if st.session_state["survey"]["responses"][emotion_ratings_key][emotion] else None
            ),
            key=f"{emotion}_rating",
            horizontal=True
        )

    # Validation: Ensure all emotions have been rated
    unrated_emotions = [
        emotion for emotion, rating in st.session_state["survey"]["responses"][emotion_ratings_key].items()
        if rating is None
    ]

    if unrated_emotions:
        st.warning(f"You need to rate all emotions before you can proceed.")
        return

    # Identify the highest-ranking emotion(s)
    ratings = st.session_state["survey"]["responses"][emotion_ratings_key]
    numeric_ratings = {emotion: scale.index(rating) for emotion, rating in ratings.items() if rating is not None}
    # Initialize tied_emotions as an empty list to avoid UnboundLocalError
    tied_emotions = []
    
    if numeric_ratings:
        max_rating_value = max(numeric_ratings.values())  # Find the highest numeric rating
        tied_emotions = [emotion for emotion, value in numeric_ratings.items() if value == max_rating_value]

        if len(tied_emotions) > 1:
            # Validate the existing tie breaker value
            if st.session_state["survey"]["responses"][tie_breaker_key] not in tied_emotions:
                st.session_state["survey"]["responses"][tie_breaker_key] = None  # Reset invalid tie breaker

            st.markdown("It seems you rated multiple emotions with the highest intensity. Please select the one you felt the strongest:")
            st.session_state["survey"]["responses"][tie_breaker_key] = st.radio(
                "Which emotion did you feel the strongest?",
                options=tied_emotions,
                index=(
                    tied_emotions.index(st.session_state["survey"]["responses"][tie_breaker_key])
                    if st.session_state["survey"]["responses"][tie_breaker_key] else 0
                ),
                key="tie_breaker_arg2"
            )
        elif len(tied_emotions) == 1:
            # If only one emotion has the highest rating, set it as the strongest emotion
            st.session_state["survey"]["responses"][tie_breaker_key] = tied_emotions[0]
        else:
            # If no emotions are rated, clear the tie breaker
            st.session_state["survey"]["responses"][tie_breaker_key] = None


    # Render the fourth question: Why do you feel this emotion?
    st.session_state["survey"]["responses"][emotion_reason_key] = st.text_area(
        "Please shortly explain why you feel these emotions.",
        value=st.session_state["survey"]["responses"][emotion_reason_key]
    )

    # Determine validation keys based on tie situation
    validation_keys = [emotion_ratings_key, emotion_reason_key]
    if len(tied_emotions) > 1:  # Only add tie_breaker_key if there was a tie
        validation_keys.append(tie_breaker_key)

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")
    
    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)





def page_argument_emotion_arg2():

    # Validate that the instance list has at least two arguments
    if "survey" not in st.session_state or "instance" not in st.session_state["survey"] or len(st.session_state["survey"]["instance"]) < 2:
        st.error("Error: The second argument is missing. Please restart the survey or contact support.")
        return

    # Get the argument instance
    instance = st.session_state["survey"]["instance"][1]
    st.title("Your emotional reaction.")
    st.markdown(f""" We now would like to know which emotion(s) you feel when hearing the argument.
    As a reminder, the topic is "{instance['topic_normalized']}".
    Here is a reminder of the scenario and argument:<br>
    A person steps onto the stage. 
    <div class="speaker-box">The person is {instance['speaker_age']} {instance['speaker_gender']}.</div>
    The person argues:
    <div class="argument-box">{instance['argument']}
    </div>
    """, unsafe_allow_html=True)

    # Define keys for the questions
    emotion_ratings_key_arg2 = "argument_2_emotion_ratings"
    emotion_reason_key_arg2 = "argument_2_emotion_reason"
    tie_breaker_key_arg2 = "argument_2_tie_breaker"


    # Initialize session state for the questions if they don't exist
    if emotion_ratings_key_arg2 not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][emotion_ratings_key_arg2] = {}
    if emotion_reason_key_arg2 not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][emotion_reason_key_arg2] = ""
    if tie_breaker_key_arg2 not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][tie_breaker_key_arg2] = None

    st.markdown("Please answer all following questions in your role as a participant in the town hall meeting.")

    # Render the third question: Rate your emotions
    st.markdown(rf"$\textsf{{\large How strongly do you feel the following emotions when hearing the argument?}}$")
    emotions = ["Anger", "Disgust", "Fear", "Guilt", "Joy", "Pride", "Relief", "Sadness", "Shame", "Surprise", "Trust"]

    # Initialize emotion ratings if not already set
    for emotion in emotions:
        if emotion not in st.session_state["survey"]["responses"][emotion_ratings_key_arg2]:
            st.session_state["survey"]["responses"][emotion_ratings_key_arg2][emotion] = None

    # Render a rating scale for each emotion
    scale = ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"]
    for emotion in emotions:
        st.session_state["survey"]["responses"][emotion_ratings_key_arg2][emotion] = st.radio(
            rf"$\textsf{{\large {{{emotion}}}}}$",
            options=scale,
            index=(
                scale.index(st.session_state["survey"]["responses"][emotion_ratings_key_arg2][emotion])
                if st.session_state["survey"]["responses"][emotion_ratings_key_arg2][emotion] else None
            ),
            key=f"{emotion}_rating_arg2",
            horizontal=True
        )


    # Validation: Ensure all emotions have been rated
    unrated_emotions = [
        emotion for emotion, rating in st.session_state["survey"]["responses"][emotion_ratings_key_arg2].items()
        if rating is None
    ]

    if unrated_emotions:
        st.warning(f"You need to rate all emotions before you can proceed.")
        return

    # Identify the highest-ranking emotion(s)
    ratings = st.session_state["survey"]["responses"][emotion_ratings_key_arg2]
    numeric_ratings = {emotion: scale.index(rating) for emotion, rating in ratings.items() if rating is not None}
    tied_emotions = []
    
    if numeric_ratings:
        max_rating_value = max(numeric_ratings.values())  # Find the highest numeric rating
        tied_emotions = [emotion for emotion, value in numeric_ratings.items() if value == max_rating_value]

        if len(tied_emotions) > 1:
            # Validate the existing tie breaker value
            if st.session_state["survey"]["responses"][tie_breaker_key_arg2] not in tied_emotions:
                st.session_state["survey"]["responses"][tie_breaker_key_arg2] = None  # Reset invalid tie breaker

            st.markdown("It seems you rated multiple emotions with the highest intensity. Please select the one you felt the strongest:")
            st.session_state["survey"]["responses"][tie_breaker_key_arg2] = st.radio(
                "Which emotion did you feel the strongest?",
                options=tied_emotions,
                index=(
                    tied_emotions.index(st.session_state["survey"]["responses"][tie_breaker_key_arg2])
                    if st.session_state["survey"]["responses"][tie_breaker_key_arg2] else 0
                ),
                key="tie_breaker_arg2"
            )
        elif len(tied_emotions) == 1:
            # If only one emotion has the highest rating, set it as the strongest emotion
            st.session_state["survey"]["responses"][tie_breaker_key_arg2] = tied_emotions[0]
        else:
            # If no emotions are rated, clear the tie breaker
            st.session_state["survey"]["responses"][tie_breaker_key_arg2] = None

    # Render the fourth question: Why do you feel this emotion?
    st.session_state["survey"]["responses"][emotion_reason_key_arg2] = st.text_area(
        "Please shortly explain why you feel these emotions.",
        value=st.session_state["survey"]["responses"][emotion_reason_key_arg2]
    )

    # Determine validation keys based on tie situation
    validation_keys = [emotion_ratings_key_arg2, emotion_reason_key_arg2]
    if len(tied_emotions) > 1:  # Only add tie_breaker_key_arg2 if there was a tie
        validation_keys.append(tie_breaker_key_arg2)

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")
    
    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)


def page_before_appraisals():
    st.title("Evaluating the argument.")
    st.markdown(f""" We now ask you some questions about the argument.""")
    next_back_buttons()



def page_argument_appraisals():

    # Get the argument instance
    instance = st.session_state["survey"]["instance"][0]
    st.title("Evaluating the argument.")
    st.markdown(f"""We now ask some more questions about the argument. Please read about the speaker
    and over the argument again as a reminder:""")
    st.markdown(f"""A person steps onto the stage. 
    <div class="speaker-box">The person is {instance['speaker_age']} {instance['speaker_gender']}.</div>
    The person argues:
    <div class="argument-box">{instance['argument']}
    </div>
    """, unsafe_allow_html=True)
    st.markdown(f"""Please read over each of the following statements carefully and answer to which extend they apply in your role as a participant in the town hall meeting.""")

    # List of appraisal dimensions
    appraisal_dimensions = [
        "The argument appears sudden or abrupt to me.",
        "I try to shut the argument out of my mind.",
        "The argument is familiar to me.",
        "The argument is pleasant for me.",
        "The argument is unpleasant for me.",
        "I expect the argument to have important consequences for me.",
        "The argument leads to positive consequences for me.",
        "The argument leads to negative consequences for me.",
        "I anticipate that I can easily live with the unavoidable consequences of the argument.",
        "The consequences of the argument clash with my own standards and ideals.",
        "The consequences of the argument violate laws or socially accepted norms.",
        # immediate response
        "I feel the urge to immediately respond to the argument.",
        # attention check
        "This is an attention check, please select extremely.",
        "Processing the argument requires a great deal of energy for me.",
        "There are statements in the argument that clash with my own standards and ideals.",
        "There are statements in the argument that violate laws or socially accepted norms."
    ]

    # Display custom CSS for radio button spacing
    st.markdown("""
    <style>
    [role=radiogroup] {
        gap: 2.5rem;
    }
    </style>
    """, unsafe_allow_html=True)

    # List to store validation keys
    validation_keys = []

    # Loop through each appraisal dimension
    for i, appraisal in enumerate(appraisal_dimensions, start=1):
        # Define a unique key for each appraisal question
        appraisal_key = f"argument_1_appraisal_{i}"

        # Add the key to the validation list
        validation_keys.append(appraisal_key)

        # Initialize the session state for this question if it doesn't exist
        if appraisal_key not in st.session_state["survey"]["responses"]:
            st.session_state["survey"]["responses"][appraisal_key] = None
        

        # Render the radio buttons for each appraisal question in horizontal layout
        st.session_state["survey"]["responses"][appraisal_key] = st.radio(
            label=change_font_size(appraisal),
            options = ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
            index=([
                "Not at all", "A little", "Moderately", "Quite a bit", "Extremely"].index(
                    st.session_state["survey"]["responses"][appraisal_key]
                )
                if st.session_state["survey"]["responses"][appraisal_key] else None
            ),
            horizontal=True  # Set to horizontal layout
        )

        # Add a horizontal line for visual separation
        st.markdown("\n", unsafe_allow_html=True)

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)




def page_argument_appraisals_arg2():
    # Validate that the instance list has at least two arguments
    if "survey" not in st.session_state or "instance" not in st.session_state["survey"] or len(st.session_state["survey"]["instance"]) < 2:
        st.error("Error: The second argument is missing. Please restart the survey or contact support.")
        return

    # Get the second argument instance
    instance = st.session_state["survey"]["instance"][1]
    st.title("Evaluating the argument.")
    st.markdown(f"""We now ask some more questions about the argument. Please read about the speaker
    and over the argument again as a reminder:""")

    st.markdown(f"""A person steps onto the stage. 
    <div class="speaker-box">The person is {instance['speaker_age']} {instance['speaker_gender']}.</div>
    The person argues:
    <div class="argument-box">{instance['argument']}
    </div>
    """, unsafe_allow_html=True)

    st.markdown(f"""Please read over each of the following statements carefully and answer to which extent they apply in your role as a participant in the town hall meeting.""")


    # List of appraisal dimensions
    appraisal_dimensions = [
        "The argument appears sudden or abrupt to me.",
        "I try to shut the argument out of my mind.",
        "The argument is familiar to me.",
        "The argument is pleasant for me.",
        "The argument is unpleasant for me.",
        "This is an attention check, select a little.",
        "I expect the argument to have important consequences for me.",
        "The argument leads to positive consequences for me.",
        "The argument leads to negative consequences for me.",
        "I anticipate that I can easily live with the unavoidable consequences of the argument.",
        "The consequences of the argument clash with my own standards and ideals.",
        "The consequences of the argument violate laws or socially accepted norms.",
        "I feel the urge to immediately respond to the argument.",
        "Processing the argument requires a great deal of energy for me.",
        "There are statements in the argument that clash with my own standards and ideals.",
        "There are statements in the argument that violate laws or socially accepted norms."
    ]

    # List to store validation keys
    validation_keys = []

    # Loop through each appraisal dimension
    for i, appraisal in enumerate(appraisal_dimensions, start=1):
        # Define a unique key for each appraisal question
        appraisal_key = f"argument_2_appraisal_{i}"

        # Add the key to the validation list
        validation_keys.append(appraisal_key)

        # Initialize the session state for this question if it doesn't exist
        if appraisal_key not in st.session_state["survey"]["responses"]:
            st.session_state["survey"]["responses"][appraisal_key] = None

        # Render the radio buttons for each appraisal question in horizontal layout
        st.session_state["survey"]["responses"][appraisal_key] = st.radio(
            label=change_font_size(appraisal),
            options=["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"],
            index=(
                ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"].index(
                    st.session_state["survey"]["responses"][appraisal_key]
                )
                if st.session_state["survey"]["responses"][appraisal_key] else None
            ),
            horizontal=True  # Set to horizontal layout
        )

        # Add a horizontal line for visual separation
        st.markdown("\n", unsafe_allow_html=True)

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)




def page_argument_generation():
    # Get the argument instance
    instance = st.session_state["survey"]["instance"][0]
    st.title("Writing an argument.")
    st.markdown(f"""Now it's your turn! Something new is happening now within the town hall meeting. Please read it carefully:""", unsafe_allow_html=True)

    # Define keys for the questions
    argument_key = "generated_argument_1"
    # Initialize session state for the questions if they don't exist
    if argument_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][argument_key] = ""

    # Display the scenario
    st.markdown(f""" 
    <div class="roleplay-box">The person on the stage has spoken and leaves the podium. The organisers now pass around note cards and pens, asking everyone in the audience to write down an argument for or against the discussion topic (reminder: the discussion topic is '{instance['topic_normalized']}'). The cards will be collected, evaluated and publicly shared. The stack of cards and the box of pens have now arrived at your seat and you take a card and a pen to contribute your argument.
    </div>
    """, unsafe_allow_html=True)

    # Render the first question: Write your argument
    st.session_state["survey"]["responses"][argument_key] = st.text_area(
        f"""Please write down the argument you would write on the card here. Please make sure to write an argument that is understandable for people who did not attend the meeting.""",
        value=st.session_state["survey"]["responses"][argument_key],
        height=200,
    )    
    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=[
        argument_key])



def page_argument_generation_labels():  
 
    st.title("Evaluate your own argument.")
    emo_intent_key = "generated_argument_1_emo_intent"
    tie_breaker_key = "generated_argument_1_tie_breaker"
    convincingness_key = "generated_argument_1_convincingness"
    manipulation_key = "generated_argument_1_manipulation"
    interest_key = "generated_argument_1_interest"
    boredom_key = "generated_argument_1_boredom"

    # Initialize session state for the questions if they don't exist
    if emo_intent_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][emo_intent_key] = {}
    if tie_breaker_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][tie_breaker_key] = None
    if convincingness_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][convincingness_key] = None
    if manipulation_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][manipulation_key] = None
    if interest_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][interest_key] = None
    if boredom_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][boredom_key] = None

    st.markdown(rf"$\textsf{{\large Please indicate which emotions you wanted to evoke in the person that hears your argument.}}$")

    emotions = ["Anger", "Disgust", "Fear", "Guilt", "Joy", "Pride", "Relief", "Sadness", "Shame",
                 "Surprise", "Trust"]

    # Render a rating scale for each emotion
    scale = ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"]
    for emotion in emotions:
        if emotion not in st.session_state["survey"]["responses"][emo_intent_key]:
            st.session_state["survey"]["responses"][emo_intent_key][emotion] = None

        st.session_state["survey"]["responses"][emo_intent_key][emotion] = st.radio(
            rf"$\textsf{{\large {{{emotion}}}}}$",
            options=scale,
            index=(
                scale.index(st.session_state["survey"]["responses"][emo_intent_key][emotion])
                if st.session_state["survey"]["responses"][emo_intent_key][emotion] else None
            ),
            key=f"{emotion}_rating",
            horizontal=True
        )


    # Validation: Ensure all emotions have been rated
    unrated_emotions = [
        emotion for emotion, rating in st.session_state["survey"]["responses"][emo_intent_key].items()
        if rating is None
    ]

    if unrated_emotions:
        st.warning(f"You need to rate all emotions before you can proceed.")
        return

    # Identify the highest-ranking emotion(s)
    ratings = st.session_state["survey"]["responses"][emo_intent_key]
    numeric_ratings = {emotion: scale.index(rating) for emotion, rating in ratings.items() if rating is not None}
    tied_emotions = []
    
    if numeric_ratings:
        max_rating_value = max(numeric_ratings.values())  # Find the highest numeric rating
        tied_emotions = [emotion for emotion, value in numeric_ratings.items() if value == max_rating_value]

        if len(tied_emotions) > 1:
            # Validate the existing tie breaker value
            if st.session_state["survey"]["responses"][tie_breaker_key] not in tied_emotions:
                st.session_state["survey"]["responses"][tie_breaker_key] = None  # Reset invalid tie breaker

            st.markdown("It seems you rated multiple emotions with the highest intensity. Please select the one you felt the strongest:")
            st.session_state["survey"]["responses"][tie_breaker_key] = st.radio(
                "Which emotion did you feel the strongest?",
                options=tied_emotions,
                index=(
                    tied_emotions.index(st.session_state["survey"]["responses"][tie_breaker_key])
                    if st.session_state["survey"]["responses"][tie_breaker_key] else 0
                ),
                key="tie_breaker_arg2"
            )
        elif len(tied_emotions) == 1:
            # If only one emotion has the highest rating, set it as the strongest emotion
            st.session_state["survey"]["responses"][tie_breaker_key] = tied_emotions[0]
        else:
            # If no emotions are rated, clear the tie breaker
            st.session_state["survey"]["responses"][tie_breaker_key] = None


    st.markdown("""
    
    """)

    # Render the third question: Is your argument manipulative?
    st.session_state["survey"]["responses"][manipulation_key] = st.radio(
        rf"$\textsf{{\large How manipulative do you perceive your own argument to be?}}$",
        options=scale,
        index=(
            scale.index(st.session_state["survey"]["responses"][manipulation_key])
            if st.session_state["survey"]["responses"][manipulation_key] else None
        ),
        horizontal=True  # Set to horizontal
    )

    # Render the fourth question: How convincing is your argument?
    st.session_state["survey"]["responses"][convincingness_key] = st.radio(
        rf"$\textsf{{\large How convincing do you perceive your own argument to be?}}$",
        options=scale,
        index=(
            scale.index(st.session_state["survey"]["responses"][convincingness_key])
            if st.session_state["survey"]["responses"][convincingness_key] else None
        ),
        horizontal=True 
    )

    # Render the fifth question: How interesting is your argument?
    st.session_state["survey"]["responses"][interest_key] = st.radio(
        rf"$\textsf{{\large How interesting do you perceive your own argument to be?}}$",
        options=scale,
        index=(
            scale.index(st.session_state["survey"]["responses"][interest_key])
            if st.session_state["survey"]["responses"][interest_key] else None
        ),
        horizontal=True 
    )

    # Render the sixth question: How boring is your argument?
    st.session_state["survey"]["responses"][boredom_key] = st.radio(
        rf"$\textsf{{\large How boring do you perceive your own argument to be?}}$",
        options=scale,
        index=(
            scale.index(st.session_state["survey"]["responses"][boredom_key])
            if st.session_state["survey"]["responses"][boredom_key] else None
        ),
        horizontal=True 
    )

    # Determine validation keys based on tie situation
    validation_keys = [emo_intent_key, manipulation_key, convincingness_key, interest_key, boredom_key]
    if len(tied_emotions) > 1:  # Only add tie_breaker_key if there was a tie
        validation_keys.append(tie_breaker_key)

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)


def page_argument_generation_arg2():

    # Get the second argument instance
    instance = st.session_state["survey"]["instance"][1]
    st.title("Writing an argument.")
    st.markdown(f"""Now it's your turn! Something new is happening now within the town hall meeting. Please read it carefully:""", unsafe_allow_html=True)

    # Define keys for the questions
    argument_key = "generated_argument_2"
    # Initialize session state for the questions if they don't exist
    if argument_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][argument_key] = ""

    # Display the scenario
    st.markdown(f""" 
    <div class="roleplay-box">The person on the stage has spoken and leaves the podium. The organisers now pass around note cards and pens, asking everyone in the audience to write down an argument for or against the discussion topic (reminder: the discussion topic is '{instance['topic_normalized']}'). The cards will be collected, evaluated and publicly shared. The stack of cards and the box of pens have now arrived at your seat and you take a card and a pen to contribute your argument.
    </div>
    """, unsafe_allow_html=True)

    # Render the first question: Write your argument
    st.session_state["survey"]["responses"][argument_key] = st.text_area(
        f"""Please write down the argument you would write on the card here. Please make sure to write an argument that is understandable for people who did not attend the meeting.""",
        value=st.session_state["survey"]["responses"][argument_key],
        height=200,
    )
    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=[
        argument_key
    ])



def page_argument_generation_labels_arg2():  
    st.title("Evaluate your own argument.")
    
    emo_intent_key_arg2 = "generated_argument_2_emo_intent"
    tie_breaker_key_arg2 = "generated_argument_2_tie_breaker"
    convincingness_key = "generated_argument_2_convincingness"
    manipulation_key = "generated_argument_2_manipulation"
    interest_key = "generated_argument_2_interest"
    boredom_key = "generated_argument_2_boredom"

    # Initialize session state for the questions if they don't exist
    if emo_intent_key_arg2 not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][emo_intent_key_arg2] = {}
    if tie_breaker_key_arg2 not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][tie_breaker_key_arg2] = None
    if convincingness_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][convincingness_key] = None
    if manipulation_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][manipulation_key] = None
    if interest_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][interest_key] = None
    if boredom_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][boredom_key] = None

    st.markdown(rf"$\textsf{{\large Please indicate which emotions you intended to evoke in the person that hears your argument.}}$")

    emotions = ["Anger", "Disgust", "Fear", "Guilt", "Joy", "Pride", "Relief", "Sadness", "Shame", "Surprise", "Trust"]

    # Render a rating scale for each emotion
    scale = ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"]
    for emotion in emotions:
        if emotion not in st.session_state["survey"]["responses"][emo_intent_key_arg2]:
            st.session_state["survey"]["responses"][emo_intent_key_arg2][emotion] = None

        st.session_state["survey"]["responses"][emo_intent_key_arg2][emotion] = st.radio(
            rf"$\textsf{{\large {{{emotion}}}}}$",
            options=scale,
            index=(
                scale.index(st.session_state["survey"]["responses"][emo_intent_key_arg2][emotion])
                if st.session_state["survey"]["responses"][emo_intent_key_arg2][emotion] else None
            ),
            key=f"{emotion}_rating_arg2",
            horizontal=True
        )

    # Validation: Ensure all emotions have been rated
    unrated_emotions = [
        emotion for emotion, rating in st.session_state["survey"]["responses"][emo_intent_key_arg2].items()
        if rating is None
    ]

    if unrated_emotions:
        st.warning(f"You need to rate all emotions before you can proceed.")
        return

    # Identify the highest-ranking emotion(s)
    ratings = st.session_state["survey"]["responses"][emo_intent_key_arg2]
    numeric_ratings = {emotion: scale.index(rating) for emotion, rating in ratings.items() if rating is not None}
    tied_emotions = []
    
    if numeric_ratings:
        max_rating_value = max(numeric_ratings.values())  # Find the highest numeric rating
        tied_emotions = [emotion for emotion, value in numeric_ratings.items() if value == max_rating_value]

        # If there is a tie at the highest ranking, ask the annotator to choose the strongest emotion
        if len(tied_emotions) > 1:
            if st.session_state["survey"]["responses"][tie_breaker_key_arg2] not in tied_emotions:
                st.session_state["survey"]["responses"][tie_breaker_key_arg2] = None  # Reset invalid tie breaker
            st.markdown("It seems you rated multiple emotions with the highest intensity. Please select the one you wanted to evoke the strongest:")
            st.session_state["survey"]["responses"][tie_breaker_key_arg2] = st.radio(
                "Which emotion did you want to evoke the most?",
                options=tied_emotions,
                index=(
                    tied_emotions.index(st.session_state["survey"]["responses"][tie_breaker_key_arg2])
                    if st.session_state["survey"]["responses"][tie_breaker_key_arg2] else None
                ),
                key="tie_breaker_arg2"
            )
        elif len(tied_emotions) == 1:
            # If only one emotion has the highest rating, set it as the strongest emotion
            st.session_state["survey"]["responses"][tie_breaker_key_arg2] = tied_emotions[0]
        else:
            # If no emotions are rated, clear the tie breaker
            st.session_state["survey"]["responses"][tie_breaker_key_arg2] = None

    st.markdown("\n")  # Add a visual separation

    # Render the third question: Is your argument manipulative?
    st.session_state["survey"]["responses"][manipulation_key] = st.radio(
        rf"$\textsf{{\large How manipulative do you perceive your own argument to be?}}$",
        options=scale,
        index=(
            scale.index(st.session_state["survey"]["responses"][manipulation_key])
            if st.session_state["survey"]["responses"][manipulation_key] else None
        ),
        horizontal=True  # Set to horizontal
    )

    # Render the fourth question: How convincing is your argument?
    st.session_state["survey"]["responses"][convincingness_key] = st.radio(
        rf"$\textsf{{\large How convincing do you perceive your own argument to be?}}$",
        options=scale,
        index=(
            scale.index(st.session_state["survey"]["responses"][convincingness_key])
            if st.session_state["survey"]["responses"][convincingness_key] else None
        ),
        horizontal=True 
    )

    # Render the fifth question: How interesting is your argument?
    st.session_state["survey"]["responses"][interest_key] = st.radio(
        rf"$\textsf{{\large How interesting do you perceive your own argument to be?}}$",
        options=scale,
        index=(
            scale.index(st.session_state["survey"]["responses"][interest_key])
            if st.session_state["survey"]["responses"][interest_key] else None
        ),
        horizontal=True 
    )

    # Render the sixth question: How boring is your argument?
    st.session_state["survey"]["responses"][boredom_key] = st.radio(
        rf"$\textsf{{\large How boring do you perceive your own argument to be?}}$",
        options=scale,
        index=(
            scale.index(st.session_state["survey"]["responses"][boredom_key])
            if st.session_state["survey"]["responses"][boredom_key] else None
        ),
        horizontal=True 
    )


    # Determine validation keys based on tie situation
    validation_keys = [emo_intent_key_arg2, manipulation_key, convincingness_key, interest_key, boredom_key]
    if len(tied_emotions) > 1:  # Only add tie_breaker_key if there was a tie
        validation_keys.append(tie_breaker_key_arg2)

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)




def page_title_before_speaker_demographics():
    st.title("Tell us more about the speaker.")
    st.markdown(f"""We will now focus on the speaker of the argument.""")
    next_back_buttons(validation_keys=[])




def page_speaker_demographics():

    # Get the argument instance
    instance = st.session_state["survey"]["instance"][0]
    st.title("Tell us more about the speaker.")
    st.markdown(f"""Here is a reminder of the speaker and the argument:
    A person steps onto the stage. 
    <div class="speaker-box">The person is {instance['speaker_age']} {instance['speaker_gender']}.</div>
    The person argues:
    <div class="argument-box">{instance['argument']}
    </div>
    """, unsafe_allow_html=True)

    st.markdown("")
    st.markdown(f"""Now please answer the following questions about how you imagined the speaker.
    """, unsafe_allow_html=True)

    # Define keys for the questions
    age_key = "contrastive_speaker_1_age"
    gender_key = "contrastive_speaker_1_gender"
    gender_specify_key = "contrastive_speaker_1_gender_specified"
    education_key = "contrastive_speaker_1_education"
    profession_key = "contrastive_speaker_1_profession"
    familiarity_key = "contrastive_speaker_1_topic_familiarity"
    additional_speaker_information = "contrastive_speaker_1_additional_information"

    # Initialize session state for the questions if they don't exist
    if age_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][age_key] = ""
    if gender_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][gender_key] = None
    if gender_specify_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][gender_specify_key] = ""
    if education_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][education_key] = None
    if familiarity_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][familiarity_key] = None
    if additional_speaker_information not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][additional_speaker_information] = ""

    # Render the first question: Age
    st.session_state["survey"]["responses"][age_key] = st.text_input(
        "What is the age of the person? Write down a number.",
        value=st.session_state["survey"]["responses"][age_key]
    )

    # Render the second question: Gender
    st.session_state["survey"]["responses"][gender_key] = st.radio(
        "What is the gender of the person? This is an attention check.",
        options=["Woman", "Man", "Non-binary / Genderqueer / Third gender", "Genderfluid / Gender non-conforming", "Questioning", "Prefer not to say", "Specify your own"],
        index=(
            ["Woman", "Man", "Non-binary / Genderqueer / Third gender", "Genderfluid / Gender non-conforming", "Questioning", "Prefer not to say", "Specify your own"].index(
                st.session_state["survey"]["responses"][gender_key]
            )
            if st.session_state["survey"]["responses"][gender_key] else None
        )
    )

    # If gender is "Specify your own," show a text area for specification
    if st.session_state["survey"]["responses"][gender_key] == "Specify your own":
        st.session_state["survey"]["responses"][gender_specify_key] = st.text_area(
            "",
            value=st.session_state["survey"]["responses"][gender_specify_key]
        )

    # Render the third question: Education
    st.session_state["survey"]["responses"][education_key] = st.radio(
        "What is the highest educational degree the person holds?",
        options=["No formal qualification", "GCSEs or equivalent", "A levels or equivalent", "Vocational qualification", "Bachelor's degree", "Master's degree (or postgraduate certificate/diploma)", "Doctorate"],
        index=(
            ["No formal qualification", "GCSEs or equivalent", "A levels or equivalent", "Vocational qualification", "Bachelor's degree", "Master's degree (or postgraduate certificate/diploma)", "Doctorate"].index(
                st.session_state["survey"]["responses"][education_key]
            )
            if st.session_state["survey"]["responses"][education_key] else None
        )
    )


    # Render the fifth question: Familiarity with the topic
    st.session_state["survey"]["responses"][familiarity_key] = st.radio(
        "How familiar did you perceive the person to be with the topic?",
        options=["Very familiar", "Familiar", "Moderately familiar", "Little familiar", "Not at all familiar"],
        index=(
            ["Very familiar", "Familiar", "Moderately familiar", "Little familiar", "Not at all familiar"].index(
                st.session_state["survey"]["responses"][familiarity_key]
            )
            if st.session_state["survey"]["responses"][familiarity_key] else None
        )
    )

    # Render the optional question: Additional speaker information
    st.session_state["survey"]["responses"][additional_speaker_information] = st.text_area(
        "Do you have any other thoughts about the person that you would like to share? (optional).",
        value=st.session_state["survey"]["responses"][additional_speaker_information]
    )

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all required questions before proceeding.")

    # Pass only the required validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=[
        age_key, gender_key, education_key, familiarity_key
    ])



def page_speaker_demographics_arg2():
    # Get the second argument instance
    instance = st.session_state["survey"]["instance"][1]
    st.title("Tell us more about the speaker.")
    st.markdown(f"""Here is a reminder of the speaker and the argument:
    A person steps onto the stage. 
    <div class="speaker-box">The person is {instance['speaker_age']} {instance['speaker_gender']}.</div>
    The person argues:
    <div class="argument-box">{instance['argument']}
    </div>
    """, unsafe_allow_html=True)

    st.markdown("")
    st.markdown(f"""Now please answer the following questions about how you imagined the speaker.
    """, unsafe_allow_html=True)

    # Define keys for the questions
    age_key = "contrastive_speaker_2_age"
    gender_key = "contrastive_speaker_2_gender"
    gender_specify_key = "contrastive_speaker_2_gender_specified"
    education_key = "contrastive_speaker_2_education"
    familiarity_key = "contrastive_speaker_2_topic_familiarity"
    additional_speaker_information = "contrastive_speaker_2_additional_information"
    attention_check_last_page_key = "contrastive_speaker_2_attention_check_last_page"

    # Initialize session state for the questions if they don't exist
    if age_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][age_key] = ""
    if gender_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][gender_key] = None
    if gender_specify_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][gender_specify_key] = ""
    if education_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][education_key] = None
    if familiarity_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][familiarity_key] = None
    if additional_speaker_information not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][additional_speaker_information] = ""
    if attention_check_last_page_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][attention_check_last_page_key] = None

    # Render the first question: Age
    st.session_state["survey"]["responses"][age_key] = st.text_input(
        "What is the age of the person? Write down a number.",
        value=st.session_state["survey"]["responses"][age_key]
    )

    # Render the second question: Gender
    st.session_state["survey"]["responses"][gender_key] = st.radio(
        "What is the gender of the person? This is an attention check.",
        options=["Woman", "Man", "Non-binary / Genderqueer / Third gender", "Genderfluid / Gender non-conforming", "Questioning", "Prefer not to say", "Specify your own"],
        index=(
            ["Woman", "Man", "Non-binary / Genderqueer / Third gender", "Genderfluid / Gender non-conforming", "Questioning", "Prefer not to say", "Specify your own"].index(
                st.session_state["survey"]["responses"][gender_key]
            )
            if st.session_state["survey"]["responses"][gender_key] else None
        )
    )

    # If gender is "Specify your own," show a text area for specification
    if st.session_state["survey"]["responses"][gender_key] == "Specify your own":
        st.session_state["survey"]["responses"][gender_specify_key] = st.text_area(
            "Please specify the gender:",
            value=st.session_state["survey"]["responses"][gender_specify_key]
        )

    # Render the third question: Education
    st.session_state["survey"]["responses"][education_key] = st.radio(
        "What is the highest educational degree the person holds?",
        options=["No formal qualification", "GCSEs or equivalent", "A levels or equivalent", "Vocational qualification", "Bachelor's degree", "Master's degree (or postgraduate certificate/diploma)", "Doctorate"],
        index=(
            ["No formal qualification", "GCSEs or equivalent", "A levels or equivalent", "Vocational qualification", "Bachelor's degree", "Master's degree (or postgraduate certificate/diploma)", "Doctorate"].index(
                st.session_state["survey"]["responses"][education_key]
            )
            if st.session_state["survey"]["responses"][education_key] else None
        )
    )

    # Render the fifth question: Familiarity with the topic
    st.session_state["survey"]["responses"][familiarity_key] = st.radio(
        "How familiar did you perceive the person to be with the topic?",
        options=["Very familiar", "Familiar", "Moderately familiar", "Little familiar", "Not at all familiar"],
        index=(
            ["Very familiar", "Familiar", "Moderately familiar", "Little familiar", "Not at all familiar"].index(
                st.session_state["survey"]["responses"][familiarity_key]
            )
            if st.session_state["survey"]["responses"][familiarity_key] else None
        )
    )

    # attention check question
    st.session_state["survey"]["responses"][attention_check_last_page_key] = st.radio(
        "Did you read the instructions carefully and answer the questions to the best of your knowledge?",
        options=["Not really", "A little", "Moderately", "Mostly", "Definetely"],
        index=(
            ["Not really", "A little", "Moderately", "Mostly", "Definetely"].index(
                st.session_state["survey"]["responses"][attention_check_last_page_key]
            )
            if st.session_state["survey"]["responses"][attention_check_last_page_key] else None
        )
    )

    # Render the optional question: Additional speaker information
    st.session_state["survey"]["responses"][additional_speaker_information] = st.text_area(
        "Do you have any other thoughts about the person that you would like to share? (optional).",
        value=st.session_state["survey"]["responses"][additional_speaker_information]
    )

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all required questions before proceeding.")

    # Pass only the required validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=[
        age_key, gender_key, education_key, familiarity_key
    ])




def page_speaker_personality():


    # Get the argument instance
    instance = st.session_state["survey"]["instance"][0]
    st.title("The personality of the speaker.")

    # Introduction and instructions
    st.markdown(f"""In the beginning of the study, we asked you to fill out a personality trait questionnaire. 
    Now please fill out the same questionnaire for the speaker.""", unsafe_allow_html=True)

    st.markdown(f"""Here are a number of personality traits that may or may not apply to the person. 
    Please choose a number below each statement to indicate the extent to which you think the person would agree 
    or disagree with that statement. You should rate the extent to which the pair of traits applies 
    to the person, even if one characteristic applies more strongly than the other.""", unsafe_allow_html=True)

    # Display the scale explanation
    st.markdown(
        """
        <div style="display: flex; justify-content: space-between; text-align: center;">
            <span>1 = Disagree<br>strongly</span>
            <span>2 = Disagree<br>moderately</span>
            <span>3 = Disagree<br>a little</span>
            <span>4 = Neither agree<br>nor disagree</span>
            <span>5 = Agree<br>a little</span>
            <span>6 = Agree<br>moderately</span>
            <span>7 = Agree<br>strongly</span>
        </div>
        """,
        unsafe_allow_html=True
    )

    # List of personality trait questions
    personality_traits_questions_contrastive = [
        "The person is extraverted, enthusiastic.",
        "The person is critical, quarrelsome.",
        "The person is dependable, self-disciplined.",
        "The person is anxious, easily upset.",
        "The person is open to new experiences, complex.",
        "The person is reserved, quiet.",
        "The person is sympathetic, warm.",
        "The person is disorganized, careless.",
        "The person is calm, emotionally stable.",
        "The person is conventional, uncreative.",
    ]

    # List to store validation keys
    validation_keys = []

    # Iterate over the personality trait questions
    for i, trait in enumerate(personality_traits_questions_contrastive, start=1):
        # Define a unique key for each question
        trait_key = f"personality_speaker_1_{i}"

        # Add the key to the validation list
        validation_keys.append(trait_key)

        # Initialize the session state for this question if it doesn't exist
        if trait_key not in st.session_state["survey"]["responses"]:
            st.session_state["survey"]["responses"][trait_key] = None

        # Render the radio buttons for each question
        st.session_state["survey"]["responses"][trait_key] = st.radio(
            label=trait,
            options=list(range(1, 8)),  # Options from 1 to 7
            index=(
                st.session_state["survey"]["responses"][trait_key] - 1
                if st.session_state["survey"]["responses"][trait_key] else None
            ),
            horizontal=True
        )

    # Display the scale explanation again at the bottom
    st.markdown(
        """
        <div style="display: flex; justify-content: space-between; text-align: center;">
            <span>1 = Disagree<br>strongly</span>
            <span>2 = Disagree<br>moderately</span>
            <span>3 = Disagree<br>a little</span>
            <span>4 = Neither agree<br>nor disagree</span>
            <span>5 = Agree<br>a little</span>
            <span>6 = Agree<br>moderately</span>
            <span>7 = Agree<br>strongly</span>
        </div>
        """,
        unsafe_allow_html=True
    )

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)



def page_speaker_personality_arg2():

    # Get the second argument instance
    instance = st.session_state["survey"]["instance"][1]
    st.title("The personality of the speaker.")

    # Introduction and instructions
    st.markdown(f"""In the beginning of the study, we asked you to fill out a personality trait questionnaire. 
    Now please fill out the same questionnaire for the speaker.""", unsafe_allow_html=True)

    st.markdown(f"""Here are a number of personality traits that may or may not apply to the person. 
    Please choose a number below each statement to indicate the extent to which you think the person would agree 
    or disagree with that statement. You should rate the extent to which the pair of traits applies 
    to the person, even if one characteristic applies more strongly than the other.""", unsafe_allow_html=True)

    # Display the scale explanation
    st.markdown(
        """
        <div style="display: flex; justify-content: space-between; text-align: center;">
            <span>1 = Disagree<br>strongly</span>
            <span>2 = Disagree<br>moderately</span>
            <span>3 = Disagree<br>a little</span>
            <span>4 = Neither agree<br>nor disagree</span>
            <span>5 = Agree<br>a little</span>
            <span>6 = Agree<br>moderately</span>
            <span>7 = Agree<br>strongly</span>
        </div>
        """,
        unsafe_allow_html=True
    )

    # List of personality trait questions
    personality_traits_questions_contrastive = [
        "The person is extraverted, enthusiastic.",
        "The person is critical, quarrelsome.",
        "The person is dependable, self-disciplined.",
        "The person is anxious, easily upset.",
        "This is an attention check. Select value one.",
        "The person is open to new experiences, complex.",
        "The person is reserved, quiet.",
        "The person is sympathetic, warm.",
        "The person is disorganized, careless.",
        "The person is calm, emotionally stable.",
        "The person is conventional, uncreative.",
    ]

    # List to store validation keys
    validation_keys = []

    # Iterate over the personality trait questions
    for i, trait in enumerate(personality_traits_questions_contrastive, start=1):
        # Define a unique key for each question
        trait_key = f"personality_speaker_2_{i}"

        # Add the key to the validation list
        validation_keys.append(trait_key)

        # Initialize the session state for this question if it doesn't exist
        if trait_key not in st.session_state["survey"]["responses"]:
            st.session_state["survey"]["responses"][trait_key] = None

        # Render the radio buttons for each question
        st.session_state["survey"]["responses"][trait_key] = st.radio(
            label=trait,
            options=list(range(1, 8)),  # Options from 1 to 7
            index=(
                st.session_state["survey"]["responses"][trait_key] - 1
                if st.session_state["survey"]["responses"][trait_key] else None
            ),
            horizontal=True
        )

    # Display the scale explanation again at the bottom
    st.markdown(
        """
        <div style="display: flex; justify-content: space-between; text-align: center;">
            <span>1 = Disagree<br>strongly</span>
            <span>2 = Disagree<br>moderately</span>
            <span>3 = Disagree<br>a little</span>
            <span>4 = Neither agree<br>nor disagree</span>
            <span>5 = Agree<br>a little</span>
            <span>6 = Agree<br>moderately</span>
            <span>7 = Agree<br>strongly</span>
        </div>
        """,
        unsafe_allow_html=True
    )

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)




def page_emotion_relevance():

    # Page title and instructions
    st.title("Relevance of emotions.")
    st.markdown(f"""We now ask you to think about the relevance of emotions in the context of 
    the argument you just heard. There are no right or wrong answers, so please answer honestly.
    """, unsafe_allow_html=True)

    # List of emotion relevance questions
    emotion_influence = [
        "The speaker identity was important for the emotion I developed.",
        "The argument itself was important for the emotion I developed.",
        "Who I am was important for the emotion I developed."
    ]

    # List to store validation keys
    validation_keys = []

    # Define the options for the radio buttons
    options = ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"]

    # Iterate over the emotion relevance questions
    for i, emotion in enumerate(emotion_influence, start=1):
        # Define a unique key for each question
        emotion_key = f"emotion_influence_argument_1_{i}"

        # Add the key to the validation list
        validation_keys.append(emotion_key)

        # Initialize the session state for this question if it doesn't exist
        if emotion_key not in st.session_state["survey"]["responses"]:
            st.session_state["survey"]["responses"][emotion_key] = None

        # Render the radio buttons for each question
        st.session_state["survey"]["responses"][emotion_key] = st.radio(
            label=change_font_size(emotion),
            options=options,  # Use the defined options
            index=(
                options.index(st.session_state["survey"]["responses"][emotion_key])
                if st.session_state["survey"]["responses"][emotion_key] in options else None
            ),
            horizontal=True  # Set to horizontal layout
        )

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)



def page_emotion_relevance_arg2():

    # Page title and instructions
    st.title("Relevance of emotions.")
    st.markdown(f"""We now ask you to think about the relevance of emotions in the context of 
    the argument you just heard. There are no right or wrong answers, so please answer honestly.
    """, unsafe_allow_html=True)

    # List of emotion relevance questions
    emotion_influence = [
        "The speaker identity was important for the emotion I developed.",
        "The argument itself was important for the emotion I developed.",
        "Who I am was important for the emotion I developed."
    ]

    # List to store validation keys
    validation_keys = []

    # Define the options for the radio buttons
    options = ["Not at all", "A little", "Moderately", "Quite a bit", "Extremely"]

    # Iterate over the emotion relevance questions
    for i, emotion in enumerate(emotion_influence, start=1):
        # Define a unique key for each question
        emotion_key = f"emotion_influence_argument_2_{i}"

        # Add the key to the validation list
        validation_keys.append(emotion_key)

        # Initialize the session state for this question if it doesn't exist
        if emotion_key not in st.session_state["survey"]["responses"]:
            st.session_state["survey"]["responses"][emotion_key] = None

        # Render the radio buttons for each question
        st.session_state["survey"]["responses"][emotion_key] = st.radio(
            label=change_font_size(emotion),
            options=options,  # Use the defined options
            index=(
                options.index(st.session_state["survey"]["responses"][emotion_key])
                if st.session_state["survey"]["responses"][emotion_key] in options else None
            ),
            horizontal=True  # Set to horizontal layout
        )

    # Display a warning if validation fails
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation keys to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)





def page_intermediate_arguments():
    st.title("Great job!")
    instance = st.session_state["survey"]["instance"][0]
    stance_intermediate_key = "stance_intermediate"
    if stance_intermediate_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][stance_intermediate_key] = None

    st.markdown(f"""You now answered all questions for the first argument. Now we would like to ask you
    for your stance towards the topic again. As a reminder, the topic is "{instance["topic_normalized"]}".""",unsafe_allow_html=True)  

    st.session_state["survey"]["responses"][stance_intermediate_key] = st.radio(
        f"""What is your stance towards the topic after hearing the first argument?""",
        options=["Strongly agree", "Agree", "Neutral", "Disagree", "Strongly disagree"],
        index=(
            ["Strongly agree", "Agree", "Neutral", "Disagree", "Strongly disagree"].index(
                st.session_state["survey"]["responses"][stance_intermediate_key]
            )
            if st.session_state["survey"]["responses"][stance_intermediate_key] else None
        )
    )

    st.markdown(f"""You are still a participant in the town hall meeting. A new speaker now steps
    onto the stage and presents a new argument. You will have to answer questions about that argument.""", 
    unsafe_allow_html=True)

    st.session_state["survey"]["responses"]["feedback_intermediate"] = st.text_area(
        f"""Do you have any comments or feedback so far? You will have the option to provide feedback 
        at the end of the study again."""
    )

    # List of mandatory keys
    validation_keys = [stance_intermediate_key]

    # Check if any mandatory question is unanswered
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation logic to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)


def page_participant_demographics():

    # Get the argument instance
    instance = st.session_state["survey"]["instance"][0]
    st.title(f"Almost done!")
    st.markdown(f""" We now ask you to provide some demographic information about yourself. These variables will be used in the study
    to investigate relationships between demographics, emotionality, and convincingness. We take your privacy very seriously.
    All data you provide will be fully anonymized.""", unsafe_allow_html=True)

    # Define keys for the questions
    age_key = "participant_age"
    gender_key = "participant_gender"
    gender_specify_key = "participant_gender_specified"
    education_key = "participant_education"
    familiarity_key = "participant_topic_familiarity"
    stance_after_key = "participant_topic_stance_after"

    # Initialize session state for all questions
    if age_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][age_key] = ""
    if gender_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][gender_key] = None
    if gender_specify_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][gender_specify_key] = ""
    if education_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][education_key] = None
    if familiarity_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][familiarity_key] = None
    if stance_after_key not in st.session_state["survey"]["responses"]:
        st.session_state["survey"]["responses"][stance_after_key] = None

    # Render the questions
    st.session_state["survey"]["responses"][age_key] = st.text_input(
        "How old are you? Write down a number.",
        value=st.session_state["survey"]["responses"][age_key]
    )

    st.session_state["survey"]["responses"][gender_key] = st.radio(
        "To which gender identity do you most identify?",
        options=["Woman", "Man", "Non-binary / Genderqueer / Third gender", "Genderfluid / Gender non-conforming", "Questioning", "Prefer not to say", "Specify your own"],
        index=(
            ["Woman", "Man", "Non-binary / Genderqueer / Third gender", "Genderfluid / Gender non-conforming", "Questioning", "Prefer not to say", "Specify your own"].index(
                st.session_state["survey"]["responses"][gender_key]
            )
            if st.session_state["survey"]["responses"][gender_key] else None
        )
    )

    # If gender is "Specify your own," show a text area for specification
    if st.session_state["survey"]["responses"][gender_key] == "Specify your own":
        st.session_state["survey"]["responses"][gender_specify_key] = st.text_area(
            "Please specify your gender:",
            value=st.session_state["survey"]["responses"][gender_specify_key]
        )

    st.session_state["survey"]["responses"][education_key] = st.radio(
        "What is your highest education?",
        options=["No formal qualification", "GCSEs or equivalent", "A levels or equivalent", "Vocational qualification", "Bachelor's degree", "Master's degree (or postgraduate certificate/diploma)", "Doctorate"],
        index=(
            ["No formal qualification", "GCSEs or equivalent", "A levels or equivalent", "Vocational qualification", "Bachelor's degree", "Master's degree (or postgraduate certificate/diploma)", "Doctorate"].index(
                st.session_state["survey"]["responses"][education_key]
            )
            if st.session_state["survey"]["responses"][education_key] else None
        )
    )



    st.markdown(f"""As a reminder, the discussion topic was "{instance['topic_normalized']}".""", unsafe_allow_html=True)

    st.session_state["survey"]["responses"][familiarity_key] = st.radio(
        "How familiar were you with the topic of the discussion at the beginning of the study?",
        options=["Very familiar", "Familiar", "Moderately familiar", "Little familiar", "Not at all familiar"],
        index=(
            ["Very familiar", "Familiar", "Moderately familiar", "Little familiar", "Not at all familiar"].index(
                st.session_state["survey"]["responses"][familiarity_key]
            )
            if st.session_state["survey"]["responses"][familiarity_key] else None
        )
    )

    st.session_state["survey"]["responses"][stance_after_key] = st.radio(
        f"""What is your stance towards the topic after hearing both arguments? As a reminder, the topic is "{instance['topic_normalized']}".""",
        options=["Strongly agree", "Agree", "Neutral", "Disagree", "Strongly disagree"],
        index=(
            ["Strongly agree", "Agree", "Neutral", "Disagree", "Strongly disagree"].index(
                st.session_state["survey"]["responses"][stance_after_key]
            )
            if st.session_state["survey"]["responses"][stance_after_key] else None
        )
    )

    # List of mandatory keys
    validation_keys = [age_key, gender_key, education_key, familiarity_key, stance_after_key]

    # Check if any mandatory question is unanswered
    if st.session_state.get("validation_error", False):
        st.warning("Please make sure to answer all questions before proceeding.")

    # Pass the validation logic to the next_back_buttons function
    next_back_buttons(validation_keys=validation_keys)




def page_end():
    st.title("Feedback")

    # Initialize feedback in session state if it doesn't exist
    if "survey" not in st.session_state:
        st.session_state["survey"] = {}
    if "feedback" not in st.session_state["survey"]:
        st.session_state["survey"]["feedback"] = ""

    st.session_state["survey"]["responses"]["feedback"] = st.text_area(
        f"""If you let us know what you liked or didn't like about this study (e.g. duration, questions), 
        we can improve it in our next version. We appreciate your valuable feedback!
        """
    )

    # Button to finish the survey
    if st.button(ui_texts['buttons']['finish']):
        st.session_state.page = 50 # Navigate to the last page
        st.rerun()  # Rerun the app to reflect the changes




def page_end2():
    st.write(ui_texts['messages']['thank_you_end'].replace("{completion_url}",
                                                           'https://app.prolific.com/submissions/complete?cc=C1933XJP'))

    # Mark the survey as complete
    st.session_state["survey"]["responses"]["complete"] = True  # Set as a boolean


    # Save the survey data
    save_survey()
    save_all_responses()

    # Finalize annotations for the completed survey
    try:
        finalize_annotations(st.session_state["prolific_id"], True)  # Pass the Prolific ID
        st.success("Your annotations have been successfully recorded.")
    except Exception as e:
        st.error(f"An error occurred while finalizing annotations: {e}")
    st.stop()


pages = {
# starting part
    1: page_1_welcome,
    2: page_2_loading_survey,
    3: lambda: page_dummy(4),
    4: page_emotional_state,
    5: lambda: page_dummy_3(6),
    6: page_participant_personality,
    7: lambda: page_dummy(8),
# argument 1
    8: page_stance,
    9: lambda: page_dummy(10),
    10: page_role_playing,
    11: lambda: page_dummy(12),
    12: page_participant_investement,
    13: lambda: page_dummy(14),
    14: page_argument_emo_conv,
    15: lambda: page_dummy(16),
    16: page_argument_emotion,
    17: page_before_appraisals,
    18: page_argument_appraisals,
    19: lambda: page_dummy(20),
    20: page_emotion_relevance,
    21: lambda: page_dummy(22),
    22: page_argument_generation,
    23: lambda: page_dummy(24),
    24: page_argument_generation_labels,
    25: page_title_before_speaker_demographics,
    26: page_speaker_demographics,
    27: lambda: page_dummy(28),
    28: page_speaker_personality,
    29: lambda: page_dummy_3(30),
# argument 2
    30: page_intermediate_arguments,
    31: lambda: page_dummy(32),
    32: page_argument_emo_conv_arg2,
    33: lambda: page_dummy(34),
    34: page_argument_emotion_arg2,
    35: page_before_appraisals,
    36: page_argument_appraisals_arg2,
    37: lambda: page_dummy(38),
    38: page_emotion_relevance_arg2,
    39: lambda: page_dummy(40),
    40: page_argument_generation_arg2,
    41: lambda: page_dummy(42),
    42: page_argument_generation_labels_arg2,
    43: page_title_before_speaker_demographics,
    44: page_speaker_demographics_arg2,
    45: lambda: page_dummy_3(46),
    46: page_speaker_personality_arg2,
    47: lambda: page_dummy_3(48),

# ending part
    48: page_participant_demographics,
    49: page_end,
    50: page_end2
}


# Dynamically call the function for the current page
current_page = st.session_state.get("page", 1)
if current_page in pages:
    pages[current_page]()
else:
    st.error("Page not found!")
