# Supplementary Material: Trust Me, I Can Convince You: The Contextualized Argument Appraisal Framework and the ContArgA Corpus

This zip file contains the annotated data as described in the paper and the code to run the annotation study using streamlit.

## Content
* `README.md`: this file
* `contarga_800x5_public.csv` - the annotated corpus, anonymized
* `study.py` - contains the code to run the annotation study using Streamlit
* `texts.py` - texts being called from the study.py file for the annotation study


## The ContArgA Corpus
### Overview
The ContArgA corpus is a novel resource developed to investigate how individuals emotionally and cognitively respond to arguments within context, as described in the paper Trust Me, I Can Convince You: The Contextualized Argument Appraisal Framework and the ContArgA Corpus. ContArgA situates argument exposure in a role-playing scenario, mimicking real-world contexts (a town-hall meeting). The corpus contains 4,000 individual annotations for 800 arguments sampled from existing argumentation datasets (UKPConvArg and IBM-Rank-30k), covering 39 topics with balanced pro/con stances.
Each annotation captures a rich set of variables: the dominant emotion evoked (spanning 11 categorical emotions, e.g., anger, joy), perceived convincingness, perceived manipulation, and a detailed set of cognitive appraisal dimensions (e.g., pleasantness, familiarity, consequentiality, cognitive effort). Participants also provide free-text explanations for their emotional responses and assess the influence of the argument, sender, and their own identity on their feelings.
ContArgA collects extensive demographic and personality information from both the annotator (receiver) and their perception of the argument (sender), enabling analysis of how individual differences shape responses to arguments. The corpus is designed under a perspectivist paradigm, intentionally capturing diverse and subjective appraisals rather than seeking consensus, and is a unique benchmark for studying the interplay between emotion, cognition, and persuasiveness in argument mining research.

### Structure
`contarga_800x5_public.csv` contains 800 unique English arguments. <br/>
Each argument is labeled by 5 annotators. Each argument has a unique_id with a _{annotator_number} suffix.<br/>
The corpus therefore contains human annotations for the variables:
* 'convincingness' (1-5)
* emotion intensity (1-5) for variables: 'anger', 'disgust', 'fear', 'guilt', 'joy', 'pride','relief', 'sadness', 'shame', 'surprise', 'trust'
* 'dominant_emotion' (one category from: joy, anger, fear, sadness, disgust, surprise, pride, interest, shame, guilt, trust, relief)
* appraisals (1-5) for: 'suddenness', 'suppression', 'familiarity', 'pleasantness', 'unpleasantness', 'consequencial_importance', 'positive_consequentiality', 'negative_consequentiality', 'consequence_manageability', 'internal_check', 'external_check', 'response_urgency', 'cognitive_effort', 'argument_internal_check', 'argument_external_check'
* importance of speaker, argument, receiver (1-5 for each variable): 'emotion_influenced_speaker',
       'emotion_influenced_argument', 'emotion_influenced_receiver'

Speaker Variables (the fictional speaker in our scenario, as defined by us)
* 'argument_speaker_age': the age we gave the speaker ('old' or 'young')
* 'argument_speaker_gender': the gender we gave the speaker ('man' or 'woman')

Receiver Variables (information about the annotators, i.e., participants)
* initial emotional state of the participant (1-5) for variables: 'participant_initial_anger', 'participant_initial_boredom',
       'participant_initial_disgust', 'participant_initial_fear',
       'participant_initial_guilt', 'participant_initial_interest',
       'participant_initial_joy', 'participant_initial_pride',
       'participant_initial_relief', 'participant_initial_sadness',
       'participant_initial_shame', 'participant_initial_surprise',
       'participant_initial_trust',
* stance before argument exposure, after the first argument, and after the second argument (1-5 (strongly disagree -- stronlgy agree)): 
       'participant_stance',
       'participant_stance_intermediate', 'participant_stance_after'
* 'participant_age' 
* 'participant_gender' 
* 'participant_gender_specified' (free text field for cases in which participants wanted to define their gender themselves)
* 'participant_education'
* 'participant_topic_familiarity' (1-5 (not at all familiar -- very familiar))
* personality of the participants assessed by 10 questions from the TIPI questionnaire (1-7): 'participant_TIPI01_extraverted_enthusiastic',
       'participant_TIPI02_critical_quarrelsome',
       'participant_TIPI03_dependable_self-disciplined',
       'participant_TIPI04_anxious_easily_upset',
       'participant_TIPI05_open_to_new_experiences',
       'participant_TIPI06_reserved_quiet',
       'participant_TIPI07_sympathetic_warm',
       'participant_TIPI08_disorganized_careless',
       'participant_TIPI09_calm_emotionally_stable',
       'participant_TIPI10_conventional_uncreative'

Perceived Speaker Variables:
* perceived sender personality, similar to participants TIPI questionnaire (1-7): 'speaker_TIPI01_extraverted_enthusiastic',
       'speaker_TIPI02_critical_quarrelsome',
       'speaker_TIPI03_dependable_self-disciplined',
       'speaker_TIPI04_anxious_easily_upset',
       'speaker_TIPI05_open_to_new_experiences',
       'speaker_TIPI06_reserved_quiet', 'speaker_TIPI07_sympathetic_warm',
       'speaker_TIPI08_disorganized_careless',
       'speaker_TIPI09_calm_emotionally_stable',
       'speaker_TIPI10_conventional_uncreative'
* 'perceived_speaker_age'
* 'perceived_speaker_gender'
* 'perceived_speaker_gender_specified' (free text field for cases in which participants perceived the gender of the person in a way not captured by our options given in the question about the gender)
* 'perceived_speaker_education'
* 'perceived_speaker_topic_familiarity (1-5 (not at all familiar -- very familiar))


## Citation
```
@misc{greschner2025trustmeiconvince,
      title={Trust Me, I Can Convince You: The Contextualized Argument Appraisal Framework}, 
      author={Lynn Greschner and Sabine Weber and Roman Klinger},
      year={2025},
      eprint={2509.17844},
      archivePrefix={arXiv},
      primaryClass={cs.CL},
      url={https://arxiv.org/abs/2509.17844}, 
}
```

If you have any questions, please contact lynn.greschner@uni-bamberg.de
